using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;

namespace Xanthos.Evo
{
	public class EvoSpiderEgg : BaseEvoEgg
	{
		public override IEvoCreature GetEvoCreature()
		{
			return new EvoSpider( "a mirror spider hatchling" );
		}

		[Constructable]
		public EvoSpiderEgg() : base()
		{
			Name = "a mirror spider egg";
			HatchDuration = 0.01;		// 15 minutes
			ItemID = 4313;
		}

		public EvoSpiderEgg( Serial serial ) : base ( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int)0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}